package com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricTimeResolution;
import org.springframework.lang.NonNull;

import java.time.LocalDate;

public interface MetricDashboardView {

    LocalDate getEventDay();

    String getDatePart();

    Long getResourceCount();

    Long getDownloads();

    Long getViews();

    Long getFavourites();

    Long getComments();

    /**
     * Returns the event month for the monthly time resolution only
     *
     * @param timeResolution the time resolution
     * @return the event month 1-based, 1 for January etc.
     */
    default Integer getEventMonth(@NonNull MetricTimeResolution timeResolution) {
        if (timeResolution == MetricTimeResolution.MONTHLY) {
            return Integer.parseInt(getDatePart().split("-")[1]);
        }
        return null;
    }

    /**
     * Returns the event quarter for the quarterly time resolution only
     *
     * @param timeResolution the time resolution
     * @return the event quarter 1-based, 1 for January-March etc.
     */
    default Integer getEventQuarter(@NonNull MetricTimeResolution timeResolution) {
        if (timeResolution == MetricTimeResolution.QUARTERLY) {
            return Integer.parseInt(getDatePart().split("-")[1]);
        }
        return null;
    }

    /**
     * Returns the event month for the monthly and quarterly time resolutions only
     *
     * @param timeResolution the time resolution
     * @return the event year
     */
    default Integer getEventYear(@NonNull MetricTimeResolution timeResolution) {
        return switch (timeResolution) {
            case YEARLY -> Integer.parseInt(getDatePart());
            case MONTHLY, QUARTERLY -> Integer.parseInt(getDatePart().split("-")[0]);
            default -> null;
        };
    }
}
