package com.finconsgroup.itserr.marketplace.metrics.dm.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.LocalDate;
import java.util.Map;

/**
 * <p>Data Transfer Object (DTO) representing metrics data for dashboards for different time resolutions.</p>
 * <p>
 * The DTO represents a flattened structure that can be easily used for generating dashboards.
 * Depending on the requested time resolution the different date parts
 * i.e. eventDay, eventYear, eventMonth, eventQuarter might not be included.
 */
@Schema(name = "OutputDashboardMetricsDto", description = "DTO representing a aggregated metric events for dashboard in responses")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class OutputDashboardMetricsDto {

    /**
     * The day of the event
     */
    @Schema(description = "The day of the event", example = "2026-01-01")
    private LocalDate eventDay;

    /**
     * The year of the event
     */
    @Schema(description = "The year of the event. May not be always populated.", example = "2026")
    private Integer eventYear;

    /**
     * The quarter of the year of the event
     */
    @Schema(description = "The month of the event 1-based, e.g. 1 for January. May not be always populated.", example = "1")
    private Integer eventMonth;

    /**
     * The quarter of the year of the event
     */
    @Schema(description = "The quarter of the event 1-based, e.g. 1 for Jan-Mar. May not be always populated.", example = "1")
    private Integer eventQuarter;

    /**
     * The number of resources
     */
    @Schema(description = "The number of resources.", example = "15")
    private Long resources;

    @Schema(description = "The map of metrics and corresponding values",
            example = "{" +
                    "\"catalog-item-download\": 12, " +
                    "\"catalog-item-view\": 10, " +
                    "\"catalog-item-favourite\": 15, " +
                    "\"catalog-item-comment\": 18 " +
                    "}")
    private Map<MetricDtoType, Double> metrics;

}
