package com.finconsgroup.itserr.marketplace.metrics.dm.controller;

import com.finconsgroup.itserr.marketplace.metrics.dm.api.MetricApi;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputFindDashboardMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputDashboardMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputReportMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesDailyMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesSummaryMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.ReportGranularity;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.MetricService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;

/**
 * REST controller class for handling metrics related API requests.
 *
 * <p>Implements the {@link MetricApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class MetricController implements MetricApi {

    /** Service for handling business logic related to metrics. */
    private final MetricService metricService;

    @Override
    public OutputResourcesDailyMetricsDto findResourcesDailyMetrics(
            final Set<String> resourcesIds,
            final LocalDate fromDate,
            final LocalDate toDate) {
        return metricService.findResourcesDailyMetrics(resourcesIds, fromDate, toDate);
    }

    @Override
    public OutputResourcesSummaryMetricsDto findResourcesSummaryMetrics(
            Set<String> resourcesIds,
            LocalDate toDate) {
        return metricService.findResourcesSummaryMetrics(resourcesIds, toDate);
    }

    @Override
    public List<OutputReportMetricsDto> findReportingMetrics(
            Set<String> resourcesIds,
            ReportGranularity granularity,
            LocalDate fromDate,
            LocalDate toDate) {
        return metricService.findReportingMetrics(resourcesIds,granularity, fromDate, toDate);
    }

    @Override
    @NonNull
    public List<List<OutputDashboardMetricsDto>> findDashboardMetrics(
            @NonNull List<InputFindDashboardMetricsDto> inputFindDashboardMetricsDtos) {
        return metricService.findDashboardMetrics(inputFindDashboardMetricsDtos);
    }

}
