create schema if not exists "wp2_metrics";

set schema 'wp2_metrics';

create table if not exists "metric_event"(
  id uuid not null,
  metric varchar(50) not null,
  resource_id varchar(255) not null,
  event_author varchar(255),
  event_time timestamptz(6) not null,
  creation_time timestamptz(6) not null,
  primary key (metric, id)
) PARTITION BY LIST (metric);

create index if not exists "metric_event_resource_id_idx" on "metric_event" (resource_id);
create index if not exists "metric_event_time_resource_id_idx" on "metric_event" (event_time, resource_id);
create unique index if not exists "uq_metricevent_metric_resourceid_author" on "metric_event" (metric, resource_id, event_author);

CREATE TABLE IF NOT EXISTS metric_event_catalog_item_download
  PARTITION OF metric_event
  FOR VALUES IN ('CATALOG_ITEM_DOWNLOAD');

CREATE TABLE IF NOT EXISTS metric_event_catalog_item_view
  PARTITION OF metric_event
  FOR VALUES IN ('CATALOG_ITEM_VIEW');

CREATE TABLE IF NOT EXISTS metric_event_catalog_item_favourite
  PARTITION OF metric_event
  FOR VALUES IN ('CATALOG_ITEM_FAVOURITE');

CREATE TABLE IF NOT EXISTS metric_event_catalog_item_comment
  PARTITION OF metric_event
  FOR VALUES IN ('CATALOG_ITEM_COMMENT');

CREATE MATERIALIZED VIEW IF NOT EXISTS metric_event_daily_counts
AS
SELECT
  metric,
  resource_id,
  (event_time AT TIME ZONE 'Europe/Rome')::date AS event_day,
  COUNT(*)::bigint AS events_count
FROM metric_event
GROUP BY metric, resource_id, event_day;

CREATE UNIQUE INDEX IF NOT EXISTS metric_event_daily_counts_uq
  ON metric_event_daily_counts (metric, resource_id, event_day);

CREATE INDEX IF NOT EXISTS resource_metric_ix
  ON metric_event_daily_counts (resource_id, event_day);

CREATE TABLE IF NOT EXISTS metric_interest_weight (
  metric VARCHAR(50) NOT NULL,
  weight DOUBLE PRECISION NOT NULL,
  PRIMARY KEY (metric)
);

CREATE TABLE IF NOT EXISTS "metric_event_beneficiary"(
    metric VARCHAR(50) NOT NULL,
    event_id uuid NOT NULL,
    user_ref VARCHAR(255) NOT NULL,
    PRIMARY KEY (metric, event_id, user_ref)
) PARTITION BY LIST (metric);

CREATE TABLE IF NOT EXISTS metric_event_beneficiary_catalog_item_download
    PARTITION OF metric_event_beneficiary
    FOR VALUES IN ('CATALOG_ITEM_DOWNLOAD');

CREATE TABLE IF NOT EXISTS metric_event_beneficiary_catalog_item_view
    PARTITION OF metric_event_beneficiary
    FOR VALUES IN ('CATALOG_ITEM_VIEW');

CREATE TABLE IF NOT EXISTS metric_event_beneficiary_catalog_item_favourite
    PARTITION OF metric_event_beneficiary
    FOR VALUES IN ('CATALOG_ITEM_FAVOURITE');

CREATE TABLE IF NOT EXISTS metric_event_beneficiary_catalog_item_comment
    PARTITION OF metric_event_beneficiary
    FOR VALUES IN ('CATALOG_ITEM_COMMENT');

-- TODO: cannot add constraint only if not exists because of Spring init script limitations
-- ALTER TABLE metric_event_beneficiary
--     ADD CONSTRAINT fk_metric_event_beneficiary_metric_event
--     FOREIGN KEY (metric, event_id)
--     REFERENCES metric_event (metric, id);

CREATE MATERIALIZED VIEW IF NOT EXISTS beneficiary_metric_event_daily_counts
AS
SELECT
    e.metric,
    b.user_ref,
    (e.event_time AT TIME ZONE 'Europe/Rome')::date AS event_day,
    COUNT(*)::bigint AS events_count
FROM metric_event e
         JOIN metric_event_beneficiary b ON e.metric = b.metric AND e.id = b.event_id
GROUP BY e.metric, b.user_ref, event_day;

CREATE UNIQUE INDEX IF NOT EXISTS beneficiary_metric_event_daily_counts_uq
    ON beneficiary_metric_event_daily_counts (metric, user_ref, event_day);

CREATE MATERIALIZED VIEW IF NOT EXISTS beneficiary_metric_interest
AS
SELECT
    e.metric,
    e.user_ref,
    SUM(e.events_count)::bigint AS events_count,
    SUM(e.events_count) * COALESCE(w.weight, 0) AS interest
FROM beneficiary_metric_event_daily_counts e
         LEFT JOIN metric_interest_weight w ON e.metric = w.metric
GROUP BY e.metric, e.user_ref, w.weight;

CREATE UNIQUE INDEX IF NOT EXISTS beneficiary_metric_interest_uq
    ON beneficiary_metric_interest (metric, user_ref);

CREATE INDEX IF NOT EXISTS beneficiary_metric_interest_user_ref_idx
    ON beneficiary_metric_interest (user_ref);

CREATE MATERIALIZED VIEW IF NOT EXISTS beneficiary_interest
AS
SELECT
    e.user_ref,
    SUM(e.interest) AS interest
FROM beneficiary_metric_interest e
GROUP BY e.user_ref;

CREATE UNIQUE INDEX IF NOT EXISTS beneficiary_interest_uq
    ON beneficiary_interest (user_ref);
