package com.finconsgroup.itserr.marketplace.metrics.dm.service;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourceMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputUserInterestInfoDto;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Service for managing metrics-based interest score.
 */
public interface MetricInterestService {

    /**
     * Calculates the total interest score based on the provided metrics.
     *
     * @param metrics the data transfer object (DTO) containing metrics data, where each entry represents a metric type and its corresponding value
     * @return the total calculated interest score derived from the given metrics
     */
    double getTotalInterest(OutputResourceMetricsDto metrics);

    /**
     * Retrieves detailed information about a user's interest score, including metrics comparing their performance with other event beneficiaries.
     *
     * @param userId the unique identifier of the user whose interest information is being retrieved
     * @return an instance of {@code OutputUserInterestInfoDto} containing the user's interest score and related metrics
     */
    @NonNull
    OutputUserInterestInfoDto getUserInterestInfo(
            @NonNull UUID userId);

}
