package com.finconsgroup.itserr.marketplace.metrics.dm.mapper;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventRefDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventBeneficiaryEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import java.util.Collection;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-12T08:18:59+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class MetricEventMapperImpl implements MetricEventMapper {

    @Autowired
    private BeneficiaryMapper beneficiaryMapper;

    @Override
    public MetricEventEntity toEntity(MetricDtoType metric, InputCreateMetricEventDto model) {
        if ( metric == null && model == null ) {
            return null;
        }

        MetricEventEntity.MetricEventEntityBuilder<?, ?> metricEventEntity = MetricEventEntity.builder();

        if ( model != null ) {
            metricEventEntity.resourceId( model.getResourceId() );
            metricEventEntity.eventAuthor( model.getEventAuthor() );
            metricEventEntity.eventTime( model.getEventTime() );
        }
        metricEventEntity.metric( metricDtoTypeToMetricType1( metric ) );

        return metricEventEntity.build();
    }

    @Override
    public OutputMetricEventDto toDto(MetricEventEntity entity, Collection<MetricEventBeneficiaryEntity> beneficiaries) {
        if ( entity == null && beneficiaries == null ) {
            return null;
        }

        OutputMetricEventDto.OutputMetricEventDtoBuilder outputMetricEventDto = OutputMetricEventDto.builder();

        if ( entity != null ) {
            outputMetricEventDto.id( entity.getId() );
            outputMetricEventDto.metric( metricTypeToMetricDtoType1( entity.getMetric() ) );
            outputMetricEventDto.resourceId( entity.getResourceId() );
            outputMetricEventDto.eventAuthor( entity.getEventAuthor() );
            outputMetricEventDto.eventTime( entity.getEventTime() );
            outputMetricEventDto.creationTime( entity.getCreationTime() );
        }
        outputMetricEventDto.beneficiaries( beneficiaryMapper.toDtoList( beneficiaries ) );

        return outputMetricEventDto.build();
    }

    @Override
    public OutputMetricEventRefDto toRefDto(MetricEventEntity entity) {
        if ( entity == null ) {
            return null;
        }

        OutputMetricEventRefDto.OutputMetricEventRefDtoBuilder outputMetricEventRefDto = OutputMetricEventRefDto.builder();

        outputMetricEventRefDto.id( entity.getId() );
        outputMetricEventRefDto.metric( metricTypeToMetricDtoType1( entity.getMetric() ) );
        outputMetricEventRefDto.resourceId( entity.getResourceId() );
        outputMetricEventRefDto.eventAuthor( entity.getEventAuthor() );
        outputMetricEventRefDto.eventTime( entity.getEventTime() );
        outputMetricEventRefDto.creationTime( entity.getCreationTime() );

        return outputMetricEventRefDto.build();
    }

    protected MetricType metricDtoTypeToMetricType1(MetricDtoType metricDtoType) {
        if ( metricDtoType == null ) {
            return null;
        }

        MetricType metricType;

        switch ( metricDtoType ) {
            case CATALOG_ITEM_DOWNLOAD: metricType = MetricType.CATALOG_ITEM_DOWNLOAD;
            break;
            case CATALOG_ITEM_VIEW: metricType = MetricType.CATALOG_ITEM_VIEW;
            break;
            case CATALOG_ITEM_FAVOURITE: metricType = MetricType.CATALOG_ITEM_FAVOURITE;
            break;
            case CATALOG_ITEM_COMMENT: metricType = MetricType.CATALOG_ITEM_COMMENT;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + metricDtoType );
        }

        return metricType;
    }

    protected MetricDtoType metricTypeToMetricDtoType1(MetricType metricType) {
        if ( metricType == null ) {
            return null;
        }

        MetricDtoType metricDtoType;

        switch ( metricType ) {
            case CATALOG_ITEM_DOWNLOAD: metricDtoType = MetricDtoType.CATALOG_ITEM_DOWNLOAD;
            break;
            case CATALOG_ITEM_VIEW: metricDtoType = MetricDtoType.CATALOG_ITEM_VIEW;
            break;
            case CATALOG_ITEM_FAVOURITE: metricDtoType = MetricDtoType.CATALOG_ITEM_FAVOURITE;
            break;
            case CATALOG_ITEM_COMMENT: metricDtoType = MetricDtoType.CATALOG_ITEM_COMMENT;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + metricType );
        }

        return metricDtoType;
    }
}
