package com.finconsgroup.itserr.marketplace.metrics.dm.controller;

import com.finconsgroup.itserr.marketplace.metrics.dm.api.MetricEventApi;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventRefDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.MetricEventService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling MetricEvent related API requests.
 *
 * <p>Implements the {@link MetricEventApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class MetricEventController implements MetricEventApi {

    private final MetricEventService metricEventService;

    @Override
    public Page<OutputMetricEventRefDto> findAll(
            final MetricDtoType metric,
            final int pageNumber,
            final int pageSize,
            final String sort,
            final Direction direction
    ) {
        Pageable pageable = PageRequest.of(pageNumber, pageSize, direction, sort);
        return this.metricEventService.findAll(metric, pageable);
    }

    @Override
    public OutputMetricEventDto createMetricEvent(
            final MetricDtoType metric,
            final InputCreateMetricEventDto request) {
        return this.metricEventService.create(metric, request);
    }

    @Override
    public OutputMetricEventDto findById(
            final MetricDtoType metric,
            final UUID metricEventId) {
        return this.metricEventService.findById(metric, metricEventId);
    }

}
