package com.finconsgroup.itserr.marketplace.metrics.dm.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.LocalDate;

/**
 * <p>Data Transfer Object (DTO) representing metrics data for reports for different granularity.</p>
 *
 * The DTO represents a flattened structure that can be easily used for generating reports.
 * Depending on the requested granularity the resourceId and eventDay might not be included.
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class OutputReportMetricsDto {

    /** The id of the resource the event refers to */
    private String resourceId;

    /** The day of the event */
    private LocalDate eventDay;

    /** The research interest score */
    private double interest;

    /** The number of downloads */
    private long downloads;

    /** The number of views */
    private long views;

    /** The number of users who have added the resource to favourites */
    private long favourites;

    /** The number of comments on the resource */
    private long comments;

}
