package com.finconsgroup.itserr.marketplace.metrics.dm.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDate;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "metric_event_daily_counts")
@IdClass(MetricEventDailyCount.EntityId.class)
public class MetricEventDailyCount {

    @Id
    @Column(name = "metric")
    @Enumerated(EnumType.STRING)
    private MetricType metric;

    @Id
    @Column(name = "resource_id")
    private String resourceId;

    @Id
    @Column(name = "event_day")
    private LocalDate eventDay;

    @Column(name = "events_count")
    private Long eventsCount;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class EntityId implements Serializable {
        private MetricType metric;
        private String resourceId;
        private LocalDate eventDay;
    }

}
