package com.finconsgroup.itserr.marketplace.metrics.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.ZonedDateTime;
import java.util.List;

import static com.finconsgroup.itserr.marketplace.metrics.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.metrics.dm.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO for creating a metricEvent.
 */
@Schema(name = "InputMetricEvent", description = "DTO for creating a metricEvent")
@Data
@Builder
@AllArgsConstructor
public class InputCreateMetricEventDto {

    @Schema(description = "The id of the resource the event refers to", example = "123e4567-e89b-12d3-a456-426614174000")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String resourceId;

    @Schema(description = "The author of the event", example = "")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String eventAuthor;

    @Schema(description = "The time of the event", example = "2025-04-06T10:15:30+01:00")
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private ZonedDateTime eventTime;

    @Schema(description = "The event beneficiaries (the users who will benefit from the event, increasing their counters and score)")
    private List<InputBeneficiaryDto> beneficiaries;

}
