package com.finconsgroup.itserr.marketplace.metrics.dm.service;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventRefDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.exception.MetricEventNotFoundException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Service for handling business logic related to MetricEvents. This interface provides methods to retrieve, create, update, and delete MetricEvents, as well as
 * retrieve MetricEvents by category.
 *
 * <p>Example usage:
 * <pre>
 * Page<OutputMetricEventDto> MetricEvents = metricEventService.findAll(pageable);
 * </pre>
 * </p>
 */
public interface MetricEventService {

    /**
     * Creates a new metricEvent using the provided input data.
     *
     * @param metric the metric type
     * @param request the input DTO containing metricEvent details
     * @return an OutputMetricEventDto representing the created metricEvent
     */
    @NonNull
    OutputMetricEventDto create(
            @NonNull MetricDtoType metric,
            @NonNull InputCreateMetricEventDto request);

    /**
     * Retrieves a paginated list of all MetricEvents.
     *
     * @param metric the metric type
     * @param pageable the pagination information
     * @return a page of {@link OutputMetricEventRefDto} representing the MetricEvents
     */
    @NonNull
    Page<OutputMetricEventRefDto> findAll(
            @NonNull MetricDtoType metric,
            @NonNull Pageable pageable);

    /**
     * Retrieves a metricEvent by id.
     *
     * @param metric the metric type
     * @param metricEventId the id of the metricEvent to retrieve
     * @return an OutputMetricEventDto representing the metricEvent details
     * @throws MetricEventNotFoundException if no metricEvent is found with the given id
     */
    @NonNull
    OutputMetricEventDto findById(
            @NonNull MetricDtoType metric,
            @NonNull UUID metricEventId);

}
