package com.finconsgroup.itserr.marketplace.metrics.dm.repository;

import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

/**
 * {@link MetricEventRepository} repository.
 */
@Repository
public interface MetricEventRepository extends JpaRepository<MetricEventEntity, MetricEventEntity.MetricEventId> {

    /**
     * Retrieves a page of {@link MetricEventEntity} filtered by a specific metric type.
     *
     * @param metric the metric type to filter the events by
     * @param pageable the pagination information, including page number and size
     * @return a {@link Page} of {@link MetricEventEntity} matching the specified metric type
     */
    Page<MetricEventEntity> findAllByMetric(
            MetricType metric,
            Pageable pageable);

}
