package com.finconsgroup.itserr.marketplace.metrics.dm.mapper;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputBeneficiaryDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputBeneficiaryDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventBeneficiaryEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-04T16:53:21+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class BeneficiaryMapperImpl implements BeneficiaryMapper {

    @Override
    public MetricEventBeneficiaryEntity toEntity(InputBeneficiaryDto src, MetricDtoType metric, UUID eventId) {
        if ( src == null && metric == null && eventId == null ) {
            return null;
        }

        MetricEventBeneficiaryEntity.MetricEventBeneficiaryEntityBuilder metricEventBeneficiaryEntity = MetricEventBeneficiaryEntity.builder();

        if ( src != null ) {
            metricEventBeneficiaryEntity.userRef( src.getUser() );
        }
        metricEventBeneficiaryEntity.metric( metricDtoTypeToMetricType( metric ) );
        metricEventBeneficiaryEntity.eventId( eventId );

        return metricEventBeneficiaryEntity.build();
    }

    @Override
    public OutputBeneficiaryDto toDto(MetricEventBeneficiaryEntity src) {
        if ( src == null ) {
            return null;
        }

        OutputBeneficiaryDto.OutputBeneficiaryDtoBuilder outputBeneficiaryDto = OutputBeneficiaryDto.builder();

        outputBeneficiaryDto.user( src.getUserRef() );

        return outputBeneficiaryDto.build();
    }

    @Override
    public List<OutputBeneficiaryDto> toDtoList(Collection<MetricEventBeneficiaryEntity> beneficiaries) {
        if ( beneficiaries == null ) {
            return null;
        }

        List<OutputBeneficiaryDto> list = new ArrayList<OutputBeneficiaryDto>( beneficiaries.size() );
        for ( MetricEventBeneficiaryEntity metricEventBeneficiaryEntity : beneficiaries ) {
            list.add( toDto( metricEventBeneficiaryEntity ) );
        }

        return list;
    }

    protected MetricType metricDtoTypeToMetricType(MetricDtoType metricDtoType) {
        if ( metricDtoType == null ) {
            return null;
        }

        MetricType metricType;

        switch ( metricDtoType ) {
            case CATALOG_ITEM_DOWNLOAD: metricType = MetricType.CATALOG_ITEM_DOWNLOAD;
            break;
            case CATALOG_ITEM_VIEW: metricType = MetricType.CATALOG_ITEM_VIEW;
            break;
            case CATALOG_ITEM_FAVOURITE: metricType = MetricType.CATALOG_ITEM_FAVOURITE;
            break;
            case CATALOG_ITEM_COMMENT: metricType = MetricType.CATALOG_ITEM_COMMENT;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + metricDtoType );
        }

        return metricType;
    }
}
