package com.finconsgroup.itserr.marketplace.metrics.dm.entity.projection;

import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import lombok.Builder;

import java.time.LocalDate;

@Builder
public record MetricReportProjection(
        String resourceId,
        LocalDate eventDay,
        MetricType metricType,
        Long count ) {

    public MetricReportProjection(String resourceId, MetricType metricType, Long count) {
        this(resourceId, null, metricType, count);
    }

    public MetricReportProjection(LocalDate eventDate, MetricType metricType, Long count) {
        this(null, eventDate, metricType, count);
    }

    public MetricReportProjection(MetricType metricType, Long count) {
        this(null, null, metricType, count);
    }
}
