package com.finconsgroup.itserr.marketplace.metrics.dm.controller;

import com.finconsgroup.itserr.marketplace.metrics.dm.api.InterestApi;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputUserInterestInfoDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.MetricInterestService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling interest API requests.
 *
 * <p>Implements the {@link InterestApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class InterestController implements InterestApi {

    /** Service for handling business logic related to interests. */
    private final MetricInterestService metricInterestService;

    @Override
    public OutputUserInterestInfoDto getUserInterestInfo(final UUID userId) {
        return metricInterestService.getUserInterestInfo(userId);
    }

}
