package com.finconsgroup.itserr.marketplace.metrics.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Data Transfer Object (DTO) representing a user's interest information. This DTO encapsulates the user's interest score, along with contextual metrics related
 * to event beneficiaries, such as comparisons to other users.
 */
@Schema(name = "OutputUserInterestInfo", description = "DTO containing information on a user interest score")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputUserInterestInfoDto {

    @Schema(description = "The user id", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf2")
    private UUID userId;

    @Schema(description = "The user interest score", example = "135.5")
    private double interest;

    @Schema(description = "The number of events beneficiaries having a worse interest score than the user", example = "258")
    private int worseEventsBeneficiaries;

    @Schema(description = "The total number of events beneficiaries", example = "1580")
    private int totalEventsBeneficiaries;

}
