package com.finconsgroup.itserr.marketplace.metrics.dm.service;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourceMetricsDto;

/**
 * Service for managing metrics-based interest score.
 */
public interface MetricInterestService {

    /**
     * Calculates the total interest score based on the provided metrics.
     *
     * @param metrics the data transfer object (DTO) containing metrics data, where each entry represents a metric type and its corresponding value
     * @return the total calculated interest score derived from the given metrics
     */
    double getTotalInterest(OutputResourceMetricsDto metrics);

}
