package com.finconsgroup.itserr.marketplace.metrics.dm.api;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricsInterestWeightsConfigurationDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * This interface defines the contract for REST API endpoints related to metrics configurations.
 */
@Tag(
        name = "Config",
        description = "The Config API: it provides endpoints for managing metrics configurations"
)
@SecurityRequirement(name = "BearerAuth")
public interface ConfigApi {

    /**
     * Retrieves the metrics interest weights configuration.
     *
     * @return an {@link OutputMetricsInterestWeightsConfigurationDto} containing the configuration of metrics interest weights as a mapping of metric
     *         identifiers to weights
     */
    @Operation(
            summary = "Retrieve metrics interest weight configuration",
            responses = { @ApiResponse(responseCode = "200", description = "OK") }
    )
    @GetMapping(value = "/metrics/config/metrics-weights", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseStatus(HttpStatus.OK)
    OutputMetricsInterestWeightsConfigurationDto getInterestWeights();

}
