package com.finconsgroup.itserr.marketplace.metrics.bs.service.impl;

import com.finconsgroup.itserr.marketplace.metrics.bs.be.validate.MetricEventValidator;
import com.finconsgroup.itserr.marketplace.metrics.bs.client.MetricDmClient;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.exception.MetricEventConflictException;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricEventService;
import feign.FeignException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Default implementation of {@link MetricEventService} to perform operations related to metricEvent resources
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultMetricEventService implements MetricEventService {

    private final MetricDmClient metricDmClient;

    private final List<MetricEventValidator> validators;

    @NonNull
    @Override
    public OutputMetricEventDto create(
            @NonNull final MetricDtoType metric,
            @NonNull final InputCreateMetricEventDto event) {

        // Validate
        validators.forEach(validator -> validator.validate(metric, event));

        // Save
        try {
            return metricDmClient.createMetricEvent(metric.getViewValue(), event);
        } catch (final FeignException.FeignClientException.Conflict e) {
            throw new MetricEventConflictException(e);
        }

    }

}
