package com.finconsgroup.itserr.marketplace.metrics.bs.controller;

import com.finconsgroup.itserr.marketplace.metrics.bs.api.MetricEventApi;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricEventService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

/**
 * REST controller class for handling MetricEvent related API requests.
 *
 * <p>Implements the {@link MetricEventApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class MetricEventController implements MetricEventApi {

    private final MetricEventService metricEventService;

    @Override
    public OutputMetricEventDto createMetricEvent(
            final MetricDtoType metric,
            final InputCreateMetricEventDto request) {
        return metricEventService.create(metric, request);
    }

}
