/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.client;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.ReportGranularity;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.metrics.OutputMetricsInterestWeightsConfigurationDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.metrics.OutputReportMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.metrics.OutputResourcesSummaryMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.metrics.OutputUserInterestInfoDto;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface MetricDmClient {
    @PostMapping(value={"/metrics/metrics/{metricId}/events"}, consumes={"application/json"}, produces={"application/json"})
    public OutputMetricEventDto createMetricEvent(@PathVariable(value="metricId") String var1, @Valid @RequestBody InputCreateMetricEventDto var2);

    @GetMapping(value={"/metrics/metrics-summaries"}, produces={"application/json"})
    public OutputResourcesSummaryMetricsDto findResourcesSummaryMetrics(@RequestParam(value="resourceId") @NotEmpty Set<String> var1, @RequestParam(value="toDate", required=false) LocalDate var2);

    @GetMapping(value={"/metrics/config/metrics-weights"}, produces={"application/json"})
    public OutputMetricsInterestWeightsConfigurationDto getInterestWeights();

    @GetMapping(value={"/metrics/users/{userId}/interest"}, produces={"application/json"})
    public OutputUserInterestInfoDto getUserInterestInfo(@PathVariable(value="userId") UUID var1);

    @GetMapping(value={"/metrics/report/metrics-summaries"}, produces={"application/json"})
    public List<OutputReportMetricsDto> findReportingMetrics(@RequestParam(value="resourceId") Set<String> var1, @RequestParam(value="granularity") ReportGranularity var2, @RequestParam(value="fromDate") LocalDate var3, @RequestParam(value="toDate") LocalDate var4);
}

