/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.be.validate;

import com.finconsgroup.itserr.marketplace.catalog.bs.dto.OutputItemDto;
import com.finconsgroup.itserr.marketplace.catalog.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.be.validate.CatalogMetricEventValidator;
import com.finconsgroup.itserr.marketplace.metrics.bs.be.validate.MetricEventValidator;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputBeneficiaryDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.exception.MetricEventValidationException;
import com.finconsgroup.itserr.marketplace.metrics.bs.repository.CatalogRepository;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CatalogMetricEventValidator
implements MetricEventValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CatalogMetricEventValidator.class);
    private final CatalogRepository catalogRepository;

    public void validate(@NonNull MetricDtoType metric, @NonNull InputCreateMetricEventDto request) {
        if (!CatalogMetricEventValidator.isCatalogMetric((MetricDtoType)metric)) {
            return;
        }
        UUID catalogItemId = this.resolveCatalogItemId(request.getResourceId());
        UUID eventAuthor = request.getEventAuthor();
        if (eventAuthor == null) {
            throw new MetricEventValidationException("Event author is required for catalog items events");
        }
        OutputItemDto catalogItem = (OutputItemDto)this.catalogRepository.findById(catalogItemId).orElseThrow(() -> new MetricEventValidationException("Catalog item not found"));
        Set maintainerAndAuthors = CatalogMetricEventValidator.getMaintainerAndAuthors((OutputItemDto)catalogItem);
        if (maintainerAndAuthors.contains(eventAuthor.toString().toLowerCase())) {
            throw new MetricEventValidationException("Event author cannot be the same as the item maintainer or author");
        }
        ArrayList requestBeneficiaries = request.getBeneficiaries() != null ? new ArrayList(request.getBeneficiaries()) : new ArrayList();
        Set existingBeneficiaries = requestBeneficiaries.stream().map(InputBeneficiaryDto::getUser).filter(StringUtils::hasText).map(String::trim).map(String::toLowerCase).collect(Collectors.toSet());
        Set missingBeneficiaries = maintainerAndAuthors.stream().filter(id -> !existingBeneficiaries.contains(id)).collect(Collectors.toSet());
        missingBeneficiaries.stream().map(u -> InputBeneficiaryDto.builder().user(u).build()).forEach(requestBeneficiaries::add);
        request.setBeneficiaries(requestBeneficiaries);
    }

    private static boolean isCatalogMetric(MetricDtoType metric) {
        return switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$metrics$bs$dto$MetricDtoType[metric.ordinal()]) {
            case 1, 2, 3, 4, 5 -> true;
            default -> false;
        };
    }

    @NonNull
    private UUID resolveCatalogItemId(String resourceId) {
        if (!StringUtils.hasText((String)resourceId)) {
            throw new MetricEventValidationException("Resource id is required");
        }
        try {
            return UUID.fromString(resourceId);
        }
        catch (Exception e) {
            throw new MetricEventValidationException("Invalid catalog item id format (not an UUID)");
        }
    }

    private void validateNotCatalogItemAuthor(@NonNull UUID eventAuthor, @NonNull OutputItemDto item) {
        Set maintainerAndAuthorsIds = CatalogMetricEventValidator.getMaintainerAndAuthors((OutputItemDto)item);
        boolean isCatalogItemMaintainerOrAuthor = maintainerAndAuthorsIds.contains(eventAuthor.toString().toLowerCase());
        if (isCatalogItemMaintainerOrAuthor) {
            throw new MetricEventValidationException("Event author cannot be the same as the item maintainer or author");
        }
    }

    @NonNull
    private static Set<String> getMaintainerAndAuthors(@NonNull OutputItemDto item) {
        HashSet<String> maintainerAndAuthorsIds = new HashSet<String>();
        Optional.ofNullable(item.getMaintainer()).map(OutputUserProfileDto::getId).map(UUID::toString).map(String::toLowerCase).ifPresent(maintainerAndAuthorsIds::add);
        if (item.getAuthors() != null) {
            item.getAuthors().stream().filter(Objects::nonNull).map(a -> a.getId() != null ? a.getId().toString() : a.getEmail()).filter(StringUtils::hasText).map(String::trim).map(String::toLowerCase).forEach(maintainerAndAuthorsIds::add);
        }
        return maintainerAndAuthorsIds;
    }

    private UUID toUUIDNoThrow(String s) {
        if (s == null) {
            return null;
        }
        try {
            return UUID.fromString(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Generated
    public CatalogMetricEventValidator(CatalogRepository catalogRepository) {
        this.catalogRepository = catalogRepository;
    }
}

