package com.finconsgroup.itserr.marketplace.metrics.bs.service;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsInterestsDto;

/**
 * Service for managing metrics-based interest score.
 */
public interface MetricInterestService {

    /**
     * Generates a collection of interest scores based on the provided metrics data.
     *
     * This method evaluates the input metrics and maps each metric type to a corresponding interest score, enabling further analysis or categorization of
     * metrics performance.
     *
     * @param metrics the collection of metrics values mapped by their type, represented as {@link OutputMetricsDto}
     * @return a {@link OutputMetricsInterestsDto} containing the mapping of metric types to their respective interest scores
     */
    OutputMetricsInterestsDto getUserMetricsInterests(OutputMetricsDto metrics);

    /**
     * Calculates the total interest score by summing up all interest values in the provided metrics data.
     *
     * @param metrics the collection of metrics values mapped by their interest scores
     * @return the total interest score as a double
     */
    double getTotalInterest(OutputMetricsInterestsDto metrics);

}
