package com.finconsgroup.itserr.marketplace.metrics.bs.service.impl;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateUXMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.UXMetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.exception.MetricEventConflictException;
import com.finconsgroup.itserr.marketplace.metrics.bs.mapper.UXMetricEventMapper;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricEventService;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.UXMetricEventService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

/**
 * Default implementation of {@link UXMetricEventService} to perform operations related to UX metric event resources
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultUXMetricEventService implements UXMetricEventService {

    /** Service for managing and retrieving metricEvent resources. */
    private final MetricEventService metricEventService;

    /** Mapper for converting between UX metric event related DTOs. */
    private final UXMetricEventMapper uxMetricEventMapper;

    @Override
    public void create(
            @NonNull final UXMetricDtoType uxMetric,
            @NonNull final InputCreateUXMetricEventDto uxRequest) {

        final MetricDtoType metric = uxMetricEventMapper.fromUXToMetricType(uxMetric);
        final InputCreateMetricEventDto request = uxMetricEventMapper.fromUXToCreateMetricEvent(uxRequest);

        try {
            metricEventService.create(metric, request);
        } catch (final MetricEventConflictException e) {
            log.debug(
                    "Metric event already exists. metric={}, resource={}, author={}",
                    metric,
                    request.getResourceId(),
                    request.getEventAuthor());
        }

    }

}
