/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metrics.bs.bean.MetricsReportRequest;
import com.finconsgroup.itserr.marketplace.metrics.bs.client.MetricDmClient;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.ExportFileFormat;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputCatalogItemMinimalDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsComparisonDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsInfoAtDateDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsInfoAtTodayDateDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsInterestsDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.ReportGranularity;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.metrics.OutputUserInterestInfoDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.repository.CatalogRepository;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricInterestService;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricReportService;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricService;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultMetricService
implements MetricService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricService.class);
    private final CatalogRepository catalogRepository;
    private final MetricDmClient metricDmClient;
    private final MetricReportService metricReportService;
    private final MetricInterestService metricInterestService;

    public OutputMetricsComparisonDto getUserMetrics(LocalDate comparisonDate) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        Set itemsIds = this.catalogRepository.getUserItemIds(userId);
        OutputMetricsDto metrics = new OutputMetricsDto();
        OutputMetricsDto cmqMetrics = new OutputMetricsDto();
        if (!itemsIds.isEmpty()) {
            metrics.putAll((Map)this.metricDmClient.findResourcesSummaryMetrics(itemsIds, null));
            if (comparisonDate != null) {
                cmqMetrics.putAll((Map)this.metricDmClient.findResourcesSummaryMetrics(itemsIds, comparisonDate));
            }
        }
        OutputMetricsInterestsDto todayMetricsInterests = this.metricInterestService.getUserMetricsInterests(metrics);
        OutputMetricsInterestsDto cmpMetricsInterests = this.metricInterestService.getUserMetricsInterests(cmqMetrics);
        double todayInterestScore = this.metricInterestService.getTotalInterest(todayMetricsInterests);
        double cmpInterestScore = this.metricInterestService.getTotalInterest(cmpMetricsInterests);
        OutputUserInterestInfoDto interestInfo = this.metricDmClient.getUserInterestInfo(userId);
        double interestWorseUsersRatio = (double)interestInfo.getWorseEventsBeneficiaries() / (double)interestInfo.getTotalEventsBeneficiaries();
        double roundedInterestWorseUsersRatio = (double)Math.round(interestWorseUsersRatio * 100.0) / 100.0;
        return OutputMetricsComparisonDto.builder().today(((OutputMetricsInfoAtTodayDateDto.OutputMetricsInfoAtTodayDateDtoBuilder)((OutputMetricsInfoAtTodayDateDto.OutputMetricsInfoAtTodayDateDtoBuilder)((OutputMetricsInfoAtTodayDateDto.OutputMetricsInfoAtTodayDateDtoBuilder)OutputMetricsInfoAtTodayDateDto.builder().metrics(metrics)).interest(Double.valueOf(todayInterestScore))).metricsInterest(todayMetricsInterests)).interestWorseUsersRatio(Double.valueOf(roundedInterestWorseUsersRatio)).build()).cmpDate(comparisonDate != null ? ((OutputMetricsInfoAtDateDto.OutputMetricsInfoAtDateDtoBuilder)((OutputMetricsInfoAtDateDto.OutputMetricsInfoAtDateDtoBuilder)((OutputMetricsInfoAtDateDto.OutputMetricsInfoAtDateDtoBuilder)OutputMetricsInfoAtDateDto.builder().date(comparisonDate).metrics(cmqMetrics)).interest(Double.valueOf(cmpInterestScore))).metricsInterest(cmpMetricsInterests)).build() : null).build();
    }

    @NonNull
    public InputStreamResource downloadReport(@NonNull ExportFileFormat format, LocalDate fromDate, LocalDate toDate, Locale locale) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        List items = this.catalogRepository.getUserItems(userId);
        Map itemById = items.stream().collect(Collectors.toMap(OutputCatalogItemMinimalDto::getId, Function.identity()));
        Set<String> itemsIds = itemById.keySet();
        try {
            List summaryMetrics = List.of();
            List resourcesMetrics = List.of();
            if (!itemsIds.isEmpty()) {
                summaryMetrics = this.metricDmClient.findReportingMetrics(itemsIds, ReportGranularity.USER, fromDate, toDate);
                resourcesMetrics = this.metricDmClient.findReportingMetrics(itemsIds, ReportGranularity.RESOURCE, fromDate, toDate);
                resourcesMetrics.forEach(reportMetricsDto -> reportMetricsDto.setResourceTitle(((OutputCatalogItemMinimalDto)itemById.get(reportMetricsDto.getResourceId())).getTitle()));
            }
            MetricsReportRequest metricsReportRequest = MetricsReportRequest.builder().summaryMetrics(summaryMetrics).resourcesMetrics(resourcesMetrics).locale(locale).build();
            return this.metricReportService.downloadReport(format, metricsReportRequest);
        }
        catch (Exception ex) {
            throw new WP2ExecutionException((Throwable)ex);
        }
    }

    @Generated
    public DefaultMetricService(CatalogRepository catalogRepository, MetricDmClient metricDmClient, MetricReportService metricReportService, MetricInterestService metricInterestService) {
        this.catalogRepository = catalogRepository;
        this.metricDmClient = metricDmClient;
        this.metricReportService = metricReportService;
        this.metricInterestService = metricInterestService;
    }
}

