package com.finconsgroup.itserr.marketplace.metrics.bs.service;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricEventDto;
import org.springframework.lang.NonNull;

/**
 * Service for handling business logic related to MetricEvents. This interface provides methods to retrieve, create, update, and delete MetricEvents, as well as
 * retrieve MetricEvents by category.
 *
 * <p>Example usage:
 * <pre>
 * Page<OutputMetricEventDto> MetricEvents = metricEventService.findAll(pageable);
 * </pre>
 * </p>
 */
public interface MetricEventService {

    /**
     * Creates a new metricEvent using the provided input data.
     *
     * @param metric the metric type
     * @param request the input DTO containing metricEvent details
     * @return an OutputMetricEventDto representing the created metricEvent
     */
    @NonNull
    OutputMetricEventDto create(
            @NonNull MetricDtoType metric,
            @NonNull InputCreateMetricEventDto request);

}
