package com.finconsgroup.itserr.marketplace.metrics.bs.dto.metrics;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.Map;

/**
 * <p>Data Transfer Object (DTO) representing metrics data for a single resource.</p>
 *
 * <p>The DTO contains a metrics map where:
 * <ul>
 * <li>The key is a String representing the type of metric (e.g., "catalog-item-download").</li>
 * <li>The value is a Double representing the value of the metric.</li>
 * </ul>
 * </p>
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputResourceMetricsDto {

    private double interest;

    private Map<MetricDtoType, Double> metrics;

}
