package com.finconsgroup.itserr.marketplace.metrics.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.metrics.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.metrics.bs.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO for creating a UX metric event.
 */
@Data
@Builder
@AllArgsConstructor
public class InputCreateUXMetricEventDto {

    @Schema(description = "The id of the resource the event refers to", example = "123e4567-e89b-12d3-a456-426614174000")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String resourceId;

}
