package com.finconsgroup.itserr.marketplace.metrics.bs.config;

import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

/**
 * Configuration class for setting up report downloads.
 */
@Configuration
@RequiredArgsConstructor
public class ReportConfiguration {

    /** Bean name for the materialized view update scheduler */
    public static final String REPORT_SCHEDULER = "reportScheduler";

    /**
     * Creates and configures a {@link ThreadPoolTaskScheduler} for report downloads.
     *
     * @return configured ThreadPoolTaskScheduler instance
     */
    @Bean(name = REPORT_SCHEDULER)
    public ThreadPoolTaskScheduler reportScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(5);
        scheduler.setRemoveOnCancelPolicy(true);
        scheduler.initialize();
        scheduler.setThreadFactory(runnable -> new Thread(runnable, "report"));
        return scheduler;
    }

}
