/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.controller;

import com.finconsgroup.itserr.marketplace.metrics.bs.api.UserMetricApi;
import com.finconsgroup.itserr.marketplace.metrics.bs.controller.UserMetricController;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.ExportFileFormat;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsComparisonDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricService;
import java.time.LocalDate;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserMetricController
implements UserMetricApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserMetricController.class);
    private static final String DOWNLOAD_FILE_NAME_FORMAT = "attachment; filename=\"metricsReport.%s\"";
    private final MetricService metricService;

    public OutputMetricsComparisonDto getUserMetrics(LocalDate comparisonDate) {
        return this.metricService.getUserMetrics(comparisonDate);
    }

    public ResponseEntity<Resource> downloadUserMetrics(@NonNull ExportFileFormat format, LocalDate fromDate, LocalDate toDate, Locale locale) {
        String extension = switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$metrics$bs$dto$ExportFileFormat[format.ordinal()]) {
            case 1 -> "csv";
            case 2 -> "pdf";
            default -> "xlsx";
        };
        MediaType contentType = switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$metrics$bs$dto$ExportFileFormat[format.ordinal()]) {
            case 1 -> MediaType.valueOf((String)"text/csv");
            case 2 -> MediaType.APPLICATION_PDF;
            default -> MediaType.valueOf((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        };
        InputStreamResource resource = this.metricService.downloadReport(format, fromDate, toDate, locale);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{DOWNLOAD_FILE_NAME_FORMAT.formatted(extension)})).contentType(contentType).body((Object)resource);
    }

    @Generated
    public UserMetricController(MetricService metricService) {
        this.metricService = metricService;
    }
}

