package com.finconsgroup.itserr.marketplace.metrics.bs.service;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateUXMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.UXMetricDtoType;
import org.springframework.lang.NonNull;

/**
 * Service for handling business logic related to UX metric events.
 */
public interface UXMetricEventService {

    /**
     * Creates a new metricEvent using the provided input data. If the event already exists, no exception is thrown.
     *
     * @param metric the metric type
     * @param request the input DTO containing metricEvent details
     */
    void create(
            @NonNull UXMetricDtoType metric,
            @NonNull InputCreateUXMetricEventDto request);

}
