package com.finconsgroup.itserr.marketplace.metrics.bs.service;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.ExportFileFormat;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsComparisonDto;
import org.springframework.core.io.InputStreamResource;
import org.springframework.lang.NonNull;

import java.time.LocalDate;
import java.util.Locale;

/**
 * Service interface for managing and retrieving user-related metrics.
 */
public interface MetricService {

    /**
     * Retrieves metrics for the current user.
     *
     * @param comparisonDate optional date to get a second set of metrics up to the given date for comparison reasons
     * @return {@link OutputMetricsComparisonDto} containing user metrics
     */
    OutputMetricsComparisonDto getUserMetrics(LocalDate comparisonDate);

    /**
     * Download metrics report for the current user.
     *
     * @param format the export file format e.g. EXCEL
     * @param fromDate the start date of the date range (inclusive)
     * @param toDate the end date of the date range (inclusive)
     * @return the {@link InputStreamResource} to download
     */
    InputStreamResource downloadReport(@NonNull ExportFileFormat format,
                                       LocalDate fromDate,
                                       LocalDate toDate,
                                       Locale locale);

}
