package com.finconsgroup.itserr.marketplace.metrics.bs.mapper;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateUXMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.UXMetricDtoType;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

/**
 * Mapper interface for converting between UX metric event related DTOs.
 */
@Mapper(config = MapperConfiguration.class)
public interface UXMetricEventMapper {

    /**
     * Converts a {@link UXMetricDtoType} to its corresponding {@link MetricDtoType}.
     *
     * @param src the {@link UXMetricDtoType} to be converted
     * @return the corresponding {@link MetricDtoType}
     */
    MetricDtoType fromUXToMetricType(UXMetricDtoType src);

    /**
     * Converts a UX metric event DTO to a generic metric event DTO. Sets the event time to the current time during conversion.
     *
     * @param src the source UX metric event DTO to convert
     * @return the converted generic metric event DTO
     */
    @Mapping(target = "eventTime", expression = "java(java.time.ZonedDateTime.now())")
    @Mapping(target = "eventAuthor", expression = "java(com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder.getUserIdOrThrow())")
    @Mapping(target = "beneficiaries", ignore = true)
    InputCreateMetricEventDto fromUXToCreateMetricEvent(
            InputCreateUXMetricEventDto src);

}
