package com.finconsgroup.itserr.marketplace.metrics.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Data Transfer Object (DTO) representing metrics information.
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetricsInfoDto {

    /**
     * The collection of metrics values associated with the type.
     */
    @Schema(description = "The collection of metrics associated with the value")
    private OutputMetricsDto metrics;

    @Schema(description = "The interest score")
    private Double interest;

    @Schema(description = "The collection of metrics associated with the interest score")
    private OutputMetricsInterestsDto metricsInterest;

}
