package com.finconsgroup.itserr.marketplace.metrics.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;

import java.util.LinkedHashMap;

/**
 * <p>Data Transfer Object (DTO) representing a collection of metrics values.</p>
 *
 * <p>The DTO is implemented as a map where:
 * <ul>
 * <li>The key is a {@link MetricDtoType} representing the type of metric.</li>
 * <li>The value is a {@link Double} representing the value of the metric.</li>
 * </ul>
 * </p>
 */
@Schema(
        description = "Collection of metrics values mapped by their type",
        example = "{\"catalog-item-download\": 175.0, \"catalog-item-view\": 144.0}")
public class OutputMetricsDto extends LinkedHashMap<MetricDtoType, Double> {
}
