package com.finconsgroup.itserr.marketplace.metrics.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Data Transfer Object (DTO) for comparing metrics between two different dates.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Schema(description = "Contains metrics comparison between two dates")
public class OutputMetricsComparisonDto {

    /** Metrics data for the current day */
    @Schema(description = "Metrics data for the current day")
    private OutputMetricsInfoAtTodayDateDto today;

    /** Metrics data for the comparison date */
    @Schema(description = "Metrics data for the comparison date")
    private OutputMetricsInfoAtDateDto cmpDate;

}
