package com.finconsgroup.itserr.marketplace.metrics.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.metrics.bs.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.metrics.bs.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO for creating a metric event beneficiary.
 */
@Schema(name = "InputBeneficiary", description = "DTO for creating a metric event beneficiary")
@Data
@Builder
@AllArgsConstructor
public class InputBeneficiaryDto {

    @Schema(description = "The beneficiary user, expressed as an id or a mail", examples = { "123e4567-e89b-12d3-a456-426614174000", "user@mail.mail" })
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String user;

}
