package com.finconsgroup.itserr.marketplace.metrics.bs.controller.converter;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * Converter implementation that converts string values to {@link MetricDtoType} enum values.
 */
@Component
public class StringToMetricDtoTypeConverter implements Converter<String, MetricDtoType> {

    @Override
    public MetricDtoType convert(@NonNull final String source) {
        return MetricDtoType.fromViewValue(source);
    }

}
