package com.finconsgroup.itserr.marketplace.metrics.bs.controller.converter;

import org.springframework.format.Formatter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;

@Component
public class LocalDateFormatter implements Formatter<LocalDate> {

    @NonNull
    @Override
    public LocalDate parse(
            @NonNull final String text,
            @NonNull final Locale locale) {
        try {
            return LocalDate.parse(text, DateTimeFormatter.ISO_LOCAL_DATE);
        } catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid date: " + text, e);
        }
    }

    @NonNull
    @Override
    public String print(
            @NonNull final LocalDate object,
            @NonNull final Locale locale) {
        return object.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

}
