package com.finconsgroup.itserr.marketplace.metrics.bs.controller;

import com.finconsgroup.itserr.marketplace.metrics.bs.api.UXMetricEventApi;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateUXMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.UXMetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.UXMetricEventService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

/**
 * REST controller class for handling UX metric event related API requests.
 *
 * <p>Implements the {@link UXMetricEventApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class UXMetricEventController implements UXMetricEventApi {

    /** Service for managing and retrieving UX metric event resources. */
    private final UXMetricEventService uxMetricEventService;

    @Override
    public void createMetricEvent(
            final UXMetricDtoType metric,
            final InputCreateUXMetricEventDto event) {
        uxMetricEventService.create(metric, event);
    }

}
