package com.finconsgroup.itserr.marketplace.metrics.bs.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

import java.util.List;
import java.util.Locale;

import static com.finconsgroup.itserr.marketplace.metrics.bs.util.Constants.MESSAGE_SOURCE_BEAN_NAME;

@Configuration
public class WebConfiguration {

    @Bean(MESSAGE_SOURCE_BEAN_NAME)
    public ResourceBundleMessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setDefaultLocale(Locale.ENGLISH);
        messageSource.setBasename("messages.default.messages");
        messageSource.setDefaultEncoding("UTF-8");
        messageSource.setUseCodeAsDefaultMessage(true);
        return messageSource;
    }

    @Bean
    public LocaleResolver localeResolver() {
        AcceptHeaderLocaleResolver resolver = new AcceptHeaderLocaleResolver();
        resolver.setDefaultLocale(Locale.ENGLISH);
        resolver.setSupportedLocales(List.of(Locale.ENGLISH, Locale.ITALIAN));
        // If a user's Accept-Language header doesn't match a supported locale,
        // the default locale (e.g., Locale.ENGLISH) is used.
        return resolver;
    }

}
