package com.finconsgroup.itserr.marketplace.metrics.bs.client;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.userprofile.OutputUserProfileDto;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.UUID;

/**
 * Client interface for interacting with the user profile dm microservice.
 */
public interface UserProfileDmClient {

    /**
     * Retrieves an userprofile by profileId.
     *
     * @param profileId of the userprofile to fetch
     * @return the found {@link OutputUserProfileDto} and HTTP status 200 (OK)
     */
    @GetMapping(value = "/profiles/{profileId}", produces = MediaType.APPLICATION_JSON_VALUE)
    OutputUserProfileDto getById(@PathVariable("profileId") UUID profileId);

}
