package com.finconsgroup.itserr.marketplace.metrics.bs.be.validate;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import org.springframework.lang.NonNull;

/**
 * Functional interface for validating metric event creation requests.
 */
@FunctionalInterface
public interface MetricEventValidator {

    /**
     * Validates the provided metric and input request for creating a metric event.
     *
     * @param metric the type of metric to validate, represented by the {@code MetricDtoType} enum. May not be null.
     * @param request the input data for creating a metric event, encapsulated in {@code InputCreateMetricEventDto}. May not be null.
     * @throws com.finconsgroup.itserr.marketplace.metrics.bs.exception.MetricEventValidationException if the validation fails.
     */
    void validate(
            @NonNull MetricDtoType metric,
            @NonNull InputCreateMetricEventDto request);

}
