package com.finconsgroup.itserr.marketplace.metrics.bs.api;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateUXMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.UXMetricDtoType;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * This interface defines the contract for REST API endpoints related to UX metric events management.
 */
@Tag(
        name = "UXMetricEvent",
        description = "The UX MetricEvent API: it provides endpoints for managing metric events."
)
@SecurityRequirement(name = "BearerAuth")
public interface UXMetricEventApi {

    /**
     * Creates a new UX metric event.
     *
     * @param metric the metric type
     * @param event the event to be created
     */
    @Operation(
            summary = "create UX metric event",
            responses = { @ApiResponse(responseCode = "204", description = "No Content") }
    )
    @PostMapping(
            value = "/metrics/metrics/{metricId}/ux-events",
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE
    )
    @ResponseStatus(HttpStatus.NO_CONTENT)
    void createMetricEvent(
            @PathVariable("metricId") UXMetricDtoType metric,
            @Valid @RequestBody InputCreateUXMetricEventDto event);

}
