package com.finconsgroup.itserr.marketplace.metrics.bs.api;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricEventDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * This interface defines the contract for REST API endpoints related to MetricEvents Management.
 */
@Tag(
        name = "MetricEvent",
        description = "The MetricEvent API: it provides endpoints for managing metric events."
)
@SecurityRequirement(name = "BearerAuth")
public interface MetricEventApi {

    /**
     * Creates a new metricEvent.
     *
     * @param metric the metric type
     * @param inputCreateMetricEventDto the input data transfer object containing metricEvent details
     * @return the created {@link OutputMetricEventDto} and HTTP status 201 (Created)
     */
    @Operation(
            summary = "create metricEvent",
            responses = { @ApiResponse(responseCode = "201", description = "Created") }
    )
    @PostMapping(
            value = "/metrics/metrics/{metricId}/events",
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE
    )
    @ResponseStatus(HttpStatus.CREATED)
    OutputMetricEventDto createMetricEvent(
            @PathVariable("metricId") MetricDtoType metric,
            @Valid @RequestBody InputCreateMetricEventDto inputCreateMetricEventDto);

}
