/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException;
import com.finconsgroup.itserr.marketplace.metrics.bs.bean.MetricsReportRequest;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.ExportFileFormat;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.ReportType;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricReportService;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.impl.DefaultMetricReportService;
import jakarta.annotation.PostConstruct;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleCsvReportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxExporterConfiguration;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import net.sf.jasperreports.pdf.JRPdfExporter;
import net.sf.jasperreports.pdf.SimplePdfExporterConfiguration;
import net.sf.jasperreports.pdf.SimplePdfReportConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class DefaultMetricReportService
implements MetricReportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricReportService.class);
    private final MessageSource messageSource;
    private final ThreadPoolTaskScheduler reportScheduler;
    private final Map<ExportFileFormat, List<JasperReport>> jasperReportsByFormat = new EnumMap(ExportFileFormat.class);
    private final Map<ExportFileFormat, Map<Integer, ReportType>> reportTypeMapByFormat = new EnumMap(ExportFileFormat.class);

    public DefaultMetricReportService(@Qualifier(value="metricsMessageSource") MessageSource messageSource, @Qualifier(value="reportScheduler") ThreadPoolTaskScheduler reportScheduler) {
        this.messageSource = messageSource;
        this.reportScheduler = reportScheduler;
    }

    @PostConstruct
    public void init() {
        for (ExportFileFormat format : ExportFileFormat.values()) {
            int index = 0;
            ArrayList jasperReports = new ArrayList();
            HashMap<Integer, ReportType> reportTypeMap = new HashMap<Integer, ReportType>();
            if (this.addReport(jasperReports, format, ReportType.SUMMARY)) {
                reportTypeMap.put(index++, ReportType.SUMMARY);
            }
            if (this.addReport(jasperReports, format, ReportType.DETAIL)) {
                reportTypeMap.put(index, ReportType.DETAIL);
            }
            if (jasperReports.isEmpty()) continue;
            this.jasperReportsByFormat.put(format, jasperReports);
            this.reportTypeMapByFormat.put(format, reportTypeMap);
        }
    }

    public InputStreamResource downloadReport(@NonNull ExportFileFormat format, @NonNull MetricsReportRequest metricsReportRequest) {
        if (!this.jasperReportsByFormat.containsKey(format)) {
            throw new WP2BusinessException("User metrics report could not be loaded for format: " + String.valueOf(format));
        }
        try {
            HashMap parameters = new HashMap();
            this.addHeaderLabels(parameters, metricsReportRequest.locale());
            List jasperReports = (List)this.jasperReportsByFormat.get(format);
            Map reportTypeMap = (Map)this.reportTypeMapByFormat.get(format);
            ArrayList<JasperPrint> jasperPrints = new ArrayList<JasperPrint>();
            for (int i = 0; i < jasperReports.size(); ++i) {
                JasperReport jasperReport = (JasperReport)jasperReports.get(i);
                JRBeanCollectionDataSource jrDataSource = Objects.requireNonNull((ReportType)reportTypeMap.get(i)) == ReportType.SUMMARY ? new JRBeanCollectionDataSource((Collection)metricsReportRequest.summaryMetrics(), false) : new JRBeanCollectionDataSource((Collection)metricsReportRequest.resourcesMetrics(), false);
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)jrDataSource);
                jasperPrints.add(jasperPrint);
            }
            SimpleJasperReportsContext jasperReportsContext = new SimpleJasperReportsContext();
            jasperReportsContext.setProperty("net.sf.jasperreports.print.keep.full.text", Boolean.TRUE.toString());
            PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            this.reportScheduler.submit(() -> this.lambda$downloadReport$0(out, format, (JasperReportsContext)jasperReportsContext, jasperPrints, metricsReportRequest));
            return new InputStreamResource((InputStream)in);
        }
        catch (Exception ex) {
            throw new WP2ExecutionException((Throwable)ex);
        }
    }

    private boolean addReport(List<JasperReport> jasperReports, ExportFileFormat format, ReportType reportType) {
        try {
            String reportFileName = "userMetrics%sReport_%s".formatted(reportType.getValue(), format.name().toUpperCase());
            String compiledReportFilePath = "/jasperreports/compiled/%s.jasper".formatted(reportFileName);
            InputStream compiledReportStream = this.getClass().getResourceAsStream(compiledReportFilePath);
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)compiledReportStream);
            jasperReports.add(jasperReport);
            log.info("Loaded user metrics report for format: {} and report type: {} from path: {}", new Object[]{format, reportType, compiledReportFilePath});
            return true;
        }
        catch (Exception e) {
            log.error("Error loading user metrics report for format: {} and report type: {}", new Object[]{format, reportType, e});
            return false;
        }
    }

    private void addHeaderLabels(Map<String, Object> parameters, Locale locale) {
        parameters.put("hdrResourceId", this.messageSource.getMessage("report.hdrResourceId", null, locale));
        parameters.put("hdrResourceTitle", this.messageSource.getMessage("report.hdrResourceTitle", null, locale));
        parameters.put("hdrInterest", this.messageSource.getMessage("report.hdrInterest", null, locale));
        parameters.put("hdrDownloads", this.messageSource.getMessage("report.hdrDownloads", null, locale));
        parameters.put("hdrViews", this.messageSource.getMessage("report.hdrViews", null, locale));
        parameters.put("hdrFavourites", this.messageSource.getMessage("report.hdrFavourites", null, locale));
        parameters.put("hdrComments", this.messageSource.getMessage("report.hdrComments", null, locale));
    }

    private void exportToPdf(JasperReportsContext jasperReportsContext, List<JasperPrint> jasperPrints, OutputStream outputStream) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter(jasperReportsContext);
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(jasperPrints));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(outputStream));
        SimplePdfExporterConfiguration configuration = new SimplePdfExporterConfiguration();
        exporter.setConfiguration((ExporterConfiguration)configuration);
        SimplePdfReportConfiguration reportConfiguration = new SimplePdfReportConfiguration();
        exporter.setConfiguration((ReportExportConfiguration)reportConfiguration);
        exporter.exportReport();
    }

    private void exportToCsv(JasperReportsContext jasperReportsContext, List<JasperPrint> jasperPrints, OutputStream outputStream) throws JRException {
        JRCsvExporter exporter = new JRCsvExporter(jasperReportsContext);
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(jasperPrints));
        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(outputStream));
        SimpleCsvExporterConfiguration configuration = new SimpleCsvExporterConfiguration();
        exporter.setConfiguration((ExporterConfiguration)configuration);
        SimpleCsvReportConfiguration reportConfiguration = new SimpleCsvReportConfiguration();
        exporter.setConfiguration((ReportExportConfiguration)reportConfiguration);
        exporter.exportReport();
    }

    private void exportToExcel(JasperReportsContext jasperReportsContext, List<JasperPrint> jasperPrints, OutputStream outputStream, Locale locale) throws JRException {
        JRXlsxExporter exporter = new JRXlsxExporter(jasperReportsContext);
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(jasperPrints));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(outputStream));
        SimpleXlsxExporterConfiguration configuration = new SimpleXlsxExporterConfiguration();
        exporter.setConfiguration((ExporterConfiguration)configuration);
        SimpleXlsxReportConfiguration reportConfiguration = new SimpleXlsxReportConfiguration();
        reportConfiguration.setOnePagePerSheet(Boolean.valueOf(true));
        reportConfiguration.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        reportConfiguration.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        reportConfiguration.setShowGridLines(Boolean.valueOf(true));
        reportConfiguration.setWhitePageBackground(Boolean.valueOf(false));
        reportConfiguration.setDetectCellType(Boolean.valueOf(true));
        reportConfiguration.setSheetNames(new String[]{this.messageSource.getMessage("report.sheetSummary", null, locale), this.messageSource.getMessage("report.sheetDetail", null, locale)});
        exporter.setConfiguration((ReportExportConfiguration)reportConfiguration);
        exporter.exportReport();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ void lambda$downloadReport$0(PipedOutputStream out, ExportFileFormat format, JasperReportsContext jasperReportsContext, List jasperPrints, MetricsReportRequest metricsReportRequest) {
        try (PipedOutputStream pipedOutputStream = out;){
            switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$metrics$bs$dto$ExportFileFormat[format.ordinal()]) {
                case 1: {
                    this.exportToCsv(jasperReportsContext, jasperPrints, (OutputStream)out);
                    return;
                }
                case 2: {
                    this.exportToPdf(jasperReportsContext, jasperPrints, (OutputStream)out);
                    return;
                }
                default: {
                    this.exportToExcel(jasperReportsContext, jasperPrints, (OutputStream)out, metricsReportRequest.locale());
                    return;
                }
            }
        }
        catch (Exception ex) {
            log.error("Error exporting user metrics report", (Throwable)ex);
        }
    }
}

