/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.service.impl;

import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.InputCreateUXMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.UXMetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.bs.exception.MetricEventConflictException;
import com.finconsgroup.itserr.marketplace.metrics.bs.mapper.UXMetricEventMapper;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricEventService;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.UXMetricEventService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultUXMetricEventService
implements UXMetricEventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUXMetricEventService.class);
    private final MetricEventService metricEventService;
    private final UXMetricEventMapper uxMetricEventMapper;

    public void create(@NonNull UXMetricDtoType uxMetric, @NonNull InputCreateUXMetricEventDto uxRequest) {
        MetricDtoType metric = this.uxMetricEventMapper.fromUXToMetricType(uxMetric);
        InputCreateMetricEventDto request = this.uxMetricEventMapper.fromUXToCreateMetricEvent(uxRequest);
        try {
            this.metricEventService.create(metric, request);
        }
        catch (MetricEventConflictException e) {
            log.debug("Metric event already exists. metric={}, resource={}, author={}", new Object[]{metric, request.getResourceId(), request.getEventAuthor()});
        }
    }

    @Generated
    public DefaultUXMetricEventService(MetricEventService metricEventService, UXMetricEventMapper uxMetricEventMapper) {
        this.metricEventService = metricEventService;
        this.uxMetricEventMapper = uxMetricEventMapper;
    }
}

