/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.repository;

import com.finconsgroup.itserr.marketplace.catalog.bs.client.ItemClient;
import com.finconsgroup.itserr.marketplace.catalog.bs.dto.ItemStatus;
import com.finconsgroup.itserr.marketplace.catalog.bs.dto.OutputItemDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import feign.FeignException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class CatalogRepository {
    private final ItemClient itemClient;

    public Optional<OutputItemDto> findById(@NonNull UUID id) {
        try {
            return Optional.of(this.itemClient.getItemById(id));
        }
        catch (WP2ResourceNotFoundException | FeignException.NotFound e) {
            return Optional.empty();
        }
    }

    @NonNull
    public Set<String> getUserItemIds(@NonNull UUID userId) {
        Set<String> itemIds = this.itemClient.getAllItems(0, Integer.MAX_VALUE, null, null, null, null, null, userId, ItemStatus.APPROVED, null).getContent().stream().map(OutputItemDto::getId).filter(Objects::nonNull).map(UUID::toString).collect(Collectors.toSet());
        return itemIds;
    }

    @Generated
    public CatalogRepository(ItemClient itemClient) {
        this.itemClient = itemClient;
    }
}

