/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.controller.converter;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.springframework.format.Formatter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class LocalDateFormatter
implements Formatter<LocalDate> {
    @NonNull
    public LocalDate parse(@NonNull String text, @NonNull Locale locale) {
        try {
            return LocalDate.parse(text, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid date: " + text, e);
        }
    }

    @NonNull
    public String print(@NonNull LocalDate object, @NonNull Locale locale) {
        return object.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }
}

