/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.dm.authorization.HasRoles;
import com.finconsgroup.itserr.marketplace.metadata.dm.authorization.RequireMetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.ModerationResult;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.mapper.MetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.MetadataRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.specification.MetadataSpecifications;
import com.finconsgroup.itserr.marketplace.metadata.dm.service.MetadataModerationService;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultMetadataModerationService
implements MetadataModerationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetadataModerationService.class);
    private final MetadataRepository metadataRepository;
    private final MetadataMapper metadataMapper;

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    @HasRoles(value={"Member"})
    public OutputPageDto<OutputMetadataDto> getMetadataListForModeration(ModerationStatus status, String searchText, UUID userId, Pageable pageable) {
        Specification spec;
        if (status == null) {
            Specification nonStatuses = MetadataSpecifications.hasStatusNotIn(Set.of(MetadataStatus.APPROVED, MetadataStatus.REJECTED, MetadataStatus.DRAFT));
            Specification creatorStatuses = MetadataSpecifications.hasStatusIn(Set.of(MetadataStatus.APPROVED, MetadataStatus.REJECTED)).and(MetadataSpecifications.updatedBy((UUID)userId));
            spec = nonStatuses.or(creatorStatuses);
        } else {
            spec = status == ModerationStatus.PENDING ? MetadataSpecifications.hasStatusIn(Set.of(MetadataStatus.PENDING)) : MetadataSpecifications.hasStatusIn(Set.of(status.toMetadataStatus())).and(MetadataSpecifications.updatedBy((UUID)userId));
        }
        spec = spec.and(MetadataSpecifications.hasSearchText((String)searchText));
        return OutputPageDto.fromPage((Page)this.metadataRepository.findAll(spec, pageable).map(arg_0 -> ((MetadataMapper)this.metadataMapper).metadataEntityToMetadataDto(arg_0)));
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    @HasRoles(value={"Member"})
    @RequireMetadataStatus(allowed={MetadataStatus.PENDING, MetadataStatus.REJECTED, MetadataStatus.APPROVED})
    public OutputMetadataDto getMetadataForModeration(UUID metadataId) {
        MetadataEntity metadataEntity = (MetadataEntity)this.metadataRepository.findById(metadataId).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Metadata not found: %s", metadataId)));
        return this.metadataMapper.metadataEntityToMetadataDto(metadataEntity);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    @HasRoles(value={"Member"})
    @RequireMetadataStatus(allowed={MetadataStatus.PENDING})
    public OutputMetadataDto setModerationStatus(UUID metadataId, InputModerationStatusDto inputModerationStatusDto, UUID userId) {
        MetadataEntity metadataEntity = (MetadataEntity)this.metadataRepository.findById(metadataId).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Metadata not found: %s", metadataId)));
        metadataEntity.setModerationMessage(inputModerationStatusDto.getMessage());
        metadataEntity.setUpdatedBy(userId);
        ModerationResult status = inputModerationStatusDto.getStatus();
        if (status == ModerationResult.APPROVED) {
            metadataEntity.setStatus(MetadataStatus.APPROVED);
            log.info("Metadata {} approved by moderator {}", (Object)metadataId, (Object)userId);
        } else if (status == ModerationResult.REJECTED) {
            metadataEntity.setStatus(MetadataStatus.REJECTED);
            log.info("Metadata {} rejected by moderator {}", (Object)metadataId, (Object)userId);
        }
        metadataEntity = (MetadataEntity)this.metadataRepository.saveAndFlush((Object)metadataEntity);
        return this.metadataMapper.metadataEntityToMetadataDto(metadataEntity);
    }

    @Generated
    public DefaultMetadataModerationService(MetadataRepository metadataRepository, MetadataMapper metadataMapper) {
        this.metadataRepository = metadataRepository;
        this.metadataMapper = metadataMapper;
    }
}

